<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Users to Folder</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/css/materialize.min.css">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <style>
        body {
            background-color: #f5f5f5;
        }
        .container {
            margin-top: 50px;
        }
        .card-panel {
            padding: 24px;
        }
        .notification {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
            color: #fff;
            display: flex;
            align-items: center;
        }
        .notification.success { background-color: #4CAF50; }
        .notification.error { background-color: #f44336; }
        .notification.info { background-color: #2196F3; }
        .notification i { margin-right: 10px; }
    </style>
</head>
<body>

<div class="container">
    <div class="row">
        <div class="col s12 m8 offset-m2">
            <div class="card-panel z-depth-2">
                <h4 class="center-align">Add Users to a Folder</h4>

                @if(session('success'))
                    <div class="notification success">
                        <i class="material-icons">check_circle</i>
                        {{ session('success') }}
                    </div>
                @endif

                @if(session('info'))
                    <div class="notification info">
                        <i class="material-icons">info</i>
                        {{ session('info') }}
                    </div>
                @endif

                @if($errors->any())
                    <div class="notification error">
                        <i class="material-icons">error</i>
                        <div>
                            @foreach ($errors->all() as $error)
                                <div>{{ $error }}</div>
                            @endforeach
                        </div>
                    </div>
                @endif

                <form action="{{ route('folder-users.store') }}" method="POST">
                    @csrf
                    <div class="row">
                        <div class="input-field col s12">
                            <i class="material-icons prefix">folder</i>
                            <select id="folder_id" name="folder_id" required>
                                <option value="" disabled selected>Choose a folder</option>
                                @foreach($folders as $folder)
                                    <option value="{{ $folder->id }}" {{ old('folder_id') == $folder->id ? 'selected' : '' }}>
                                        {{ $folder->name }}
                                    </option>
                                @endforeach
                            </select>
                            <label for="folder_id">Select Folder</label>
                        </div>

                        <div class="input-field col s12">
                            <i class="material-icons prefix">person_add</i>
                            <textarea id="telegram_ids" name="telegram_ids" class="materialize-textarea" required>{{ old('telegram_ids') }}</textarea>
                            <label for="telegram_ids">Telegram IDs</label>
                            <span class="helper-text">Enter multiple Telegram IDs, separated by commas, spaces, or new lines.</span>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col s12 center-align">
                            <button type="submit" class="btn-large waves-effect waves-light green">
                                Add Users <i class="material-icons right">send</i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/js/materialize.min.js"></script>
<script>
    // Initialize Materialize components
    document.addEventListener('DOMContentLoaded', function() {
        M.FormSelect.init(document.querySelectorAll('select'));
    });
</script>
</body>
</html>
