<?php

namespace App\Telegram\Menus\Admin;

use App\Models\Folder;
use App\Models\User;
use SergiX44\Nutgram\Conversations\Conversation;
use SergiX44\Nutgram\Nutgram;

class GrantAccessConversation extends Conversation
{
    use Helpers;

    protected ?int $folder_id;
    protected ?string $folder_name;

    public function start(Nutgram $bot, string $folder_id): void
    {

        if (!self::authorizeAdmin($bot, $this)) return;


        $folder = Folder::find($folder_id);
        if (!$folder) {
            $bot->sendMessage('Folder not found.');
            $this->end();
            return;
        }

        $this->folder_id = $folder->id;
        $this->folder_name = $folder->name;

        $bot->sendMessage(
            "Please send the Telegram ID or @username of the user to grant access to folder '{$this->folder_name}':"
        );
        $this->next('handleUserInput');
    }

    public function handleUserInput(Nutgram $bot): void
    {
        $input = trim($bot->message()->text ?? '');

        if (is_numeric($input)) {
            $targetUser = User::where('telegram_id', $input)->first();
        } else {
            $username = ltrim($input, '@');
            $targetUser = User::where('username', $username)->first();
        }

        if (!$targetUser) {
            $bot->sendMessage("❌ User not found. Make sure they have started the bot. Please try again:");
            $this->start($bot, $this->folder_id);
            return;
        }

        if ($targetUser->folders()->where('folder_id', $this->folder_id)->exists()) {
            $bot->sendMessage("⚠️ User {$targetUser->first_name} already has access to '{$this->folder_name}'.");
        } else {
            $targetUser->folders()->syncWithoutDetaching([$this->folder_id]);
            $displayName = $targetUser->first_name . ($targetUser->username ? " (@{$targetUser->username})" : '');
            $bot->sendMessage("✅ Access granted to user {$displayName} for folder '{$this->folder_name}'.");
        }

        $this->end();
        FoldersMenu::begin($bot);
    }
}
