<?php

namespace App\Telegram\Menus\Admin;

use App\Models\Asset;
use App\Models\Folder;
use SergiX44\Nutgram\Conversations\Conversation;
use SergiX44\Nutgram\Nutgram;
use SergiX44\Nutgram\Telegram\Properties\MessageType;

class AddAssetConversation extends Conversation
{
    use Helpers;

    protected ?int $folderId = null;
    protected ?string $assetTitle = null;

    private int $perPage = 8;


    public function start(Nutgram $bot, int $page = 1): void
    {
        if (!self::authorizeAdmin($bot, $this)) return;


        $bot->sendMessage(
            "**➕ Add New Asset** (Step 1/3)**\n\nPlease send the ID of the folder:",
            parse_mode: 'Markdown');


        $this->next('askForTitle');
    }

    public function askForTitle(Nutgram $bot): void
    {
        if ($this->folderId === null) {
            $id = trim($bot->message()->text ?? '');
            $folder = Folder::on()->find($id);

            if (empty($id) || $folder === null) {
                $bot->sendMessage('❌ Folder not found!');
                $this->start($bot);
                return;
            }

            $this->folderId = $id;
        } else {
            $folder = Folder::on()->find($this->folderId);
        }


        $folderPath = $folder->getPath();
        $bot->sendMessage(
            "**➕ Add New Asset** (Step 2/3)\n📂 $folderPath\n\nNow, please send a title for your asset.",
            parse_mode: 'Markdown'
        );
        $this->next('askForAsset');
    }

    public function askForAsset(Nutgram $bot): void
    {
        $this->assetTitle = trim($bot->message()->text ?? '');
        if (empty($this->assetTitle)) {
            $bot->sendMessage('❌ The title cannot be empty. Please send a valid title.');
            $this->askForTitle($bot);
            return;
        }

        $bot->sendMessage(
            "**➕ Add New Asset** (Step 3/3)\n\nFinally, send the photo, video, document, audio, or text you want to save.",
            parse_mode: 'Markdown'
        );
        $this->next('saveAsset');
    }

    public function saveAsset(Nutgram $bot): void
    {
        $message = $bot->message();
        $type = $message->getType();
        $metadata = ['caption' => $message->caption];


        switch ($type) {
            case MessageType::TEXT:
                $fileId = $message->message_id; // For text, we can just use the message_id
                $metadata['text'] = $message->text;
                $metadata['entities'] = $message->entities;
                break;
            case MessageType::PHOTO:
                $fileId = $message->photo[array_key_last($message->photo)]->file_id; // Get the highest quality
                break;
            case MessageType::VIDEO:
                $fileId = $message->video->file_id;
                $metadata['duration'] = $message->video->duration;
                $metadata['file_name'] = $message->video->file_name;
                break;
            case MessageType::DOCUMENT:
                $fileId = $message->document->file_id;
                $metadata['file_name'] = $message->document->file_name;
                $metadata['mime_type'] = $message->document->mime_type;
                break;
            case MessageType::AUDIO:
                $fileId = $message->audio->file_id;
                $metadata['duration'] = $message->audio->duration;
                $metadata['file_name'] = $message->audio->file_name;
                break;
            default:
                $bot->sendMessage("Unsupported asset type: {$type->name}. Please send a photo, video, document, audio, or text message.");
                $this->askForAsset($bot);
                return;
        }

        Asset::create([
            'folder_id' => $this->folderId,
            'type' => $type->name,
            'file_id' => $fileId,
            'title' => $this->assetTitle,
            'metadata' => $metadata
        ]);

        $bot->sendMessage("✅ Asset '{$this->assetTitle}' saved successfully!");
//        $this->end();
        $this->askForTitle($bot);
        return;
//        AssetsMenu::begin($bot);
    }
}
