<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;

class UserController extends Controller
{
    function showAddAdmin()
    {
        return view('promote_admin');
    }

    function handleAddAdmin(Request $request)
    {
        $request->validate([
            'telegram_id' => 'required|numeric|exists:users,telegram_id',
        ]);

        $user = User::where('telegram_id', $request->input('telegram_id'))->first();
        $user->update(['is_admin' => true]);

        $successMessage = 'User with Telegram ID ' . $user->telegram_id . ' has been promoted to admin! ✨';

        return back()->with('admin_success', $successMessage);
    }
}
