<?php $__env->startSection('content'); ?>
    <h1>🔐 Grant Access</h1>
    <form action="<?php echo e(route('admin.folders.grant.access')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="mb-3">
            <label for="folder_id" class="form-label">Select Folder</label>
            <select class="form-select" id="folder_id" disabled>
                <?php if($folder): ?>
                    <option value="<?php echo e($folder->id); ?>"><?php echo e($folder->getPath()); ?></option>
                    <input type="hidden" name="folder_id" value="<?php echo e($folder->id); ?>">
                <?php endif; ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="telegram_ids" class="form-label">
                <i class="bi bi-person-plus me-1"></i> Telegram IDs
            </label>
            <textarea
                    id="telegram_ids"
                    name="telegram_ids"
                    class="form-control"
                    rows="3"
                    required><?php echo e(old('telegram_ids')); ?></textarea>
            <div class="form-text">
                Enter multiple Telegram IDs, separated by commas, spaces, or new lines.
            </div>
        </div>


        <a href="<?php echo e(route('admin.folders.index', ['folder_id=' . ($_GET['parent_id'] ?? '') ])); ?>" class="btn btn-secondary">⬅️ Back</a>
        <button type="submit" class="btn btn-success">Grant Access</button>
    </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/kurdevsv/public_html/resources/views/admin/folders/grant.blade.php ENDPATH**/ ?>