@extends('layouts.admin')

@section('content')
    <h1>➕ Create New Folder</h1>
    <form action="{{ route('admin.folders.store') }}" method="POST">
        @csrf
        <div class="mb-3">
            <label for="name" class="form-label">Folder Name</label>
            <input type="text" class="form-control" id="name" name="name" required>
        </div>

        <div class="mb-3">
            <label for="description" class="form-label">Folder Description (Optional)</label>
            <input type="text" class="form-control" id="description" name="description">
        </div>

        <div class="mb-3">
            <label for="parent_id" class="form-label">Parent Folder</label>
            <select class="form-select" id="parent_id" disabled>
                @if($parentFolder)
                    <option value="{{ $parentFolder->id }}">{{ $parentFolder->getPath() }}</option>
                    <input type="hidden" name="parent_id" value="{{ $parentFolder->id }}">
                @else
                    <option value="">-- None (Root Folder) --</option>
                @endif
            </select>
        </div>
        <a href="{{ route('admin.folders.index', ['folder_id=' . ($_GET['parent_id'] ?? '') ]) }}" class="btn btn-secondary">⬅️ Back</a>
        <button type="submit" class="btn btn-primary">Create Folder</button>
    </form>
@endsection
