<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>ناردنی پەیام لە سەر تێلێگرام</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif; }
        .result-log { background-color: #1f2937; color: #d1d5db; font-family: 'Courier New', Courier, monospace; white-space: pre-wrap; word-wrap: break-word; }
    </style>
</head>
<body class="bg-gray-100 text-gray-800">

<div class="container mx-auto p-4 md:p-8 max-w-4xl">
    <div class="bg-white rounded-lg shadow-lg p-6 md:p-8">
        <h1 class="text-2xl md:text-3xl font-bold text-center text-gray-700 mb-6">📣 پەنێلی ناردنی پەیام</h1>

        <form method="POST" action="{{ route('admin.broadcast.send') }}" class="space-y-6">
            @csrf
            <div>
                <label for="message" class="block text-lg font-medium text-gray-600 mb-2">دەقی پەیام:</label>
                <textarea name="message" id="message" rows="12" class="w-full p-3 border border-gray-300 rounded-md shadow-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition" placeholder="پەیامی خۆتان لێرە بنووسن...">{{ old('message', $message_text ?? '') }}</textarea>
                @error('message')
                <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <fieldset>
                <legend class="block text-lg font-medium text-gray-600 mb-2">ناردن بۆ:</legend>
                <div class="space-y-3">
                    <div class="flex items-center p-3 border rounded-md hover:bg-gray-50">
                        <input id="audience_active" name="audience" type="radio" value="folder" class="h-4 w-4 text-blue-600 border-gray-300 focus:ring-blue-500" {{ (old('audience', $audience ?? 'folder') === 'folder') ? 'checked' : '' }}>
                        <label for="audience_active" class="ms-3 block text-md font-medium text-gray-700">پووشەی هەژمارەکان:</label>
                        <select name="folder_id" id="folder_id" class="ms-2 p-1 border border-gray-300 rounded-md shadow-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition w-full sm:w-auto" {{ (old('audience', $audience ?? 'folder') !== 'folder') ? 'disabled' : '' }}>
                            @foreach($folders as $folder)
                                <option value="{{ $folder->id }}" {{ (old('folder_id') == $folder->id) ? 'selected' : '' }}>{{ $folder->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="flex items-center p-3 border rounded-md hover:bg-gray-50">
                        <input id="audience_all" name="audience" type="radio" value="all" class="h-4 w-4 text-blue-600 border-gray-300 focus:ring-blue-500" {{ (old('audience', $audience ?? 'folder') === 'all') ? 'checked' : '' }}>
                        <label for="audience_all" class="ms-3 block text-md font-medium text-gray-700">تەواوی هەژمارەکان</label>
                    </div>
                    <div class="flex items-center p-3 border rounded-md hover:bg-gray-50">
                        <input id="audience_specific" name="audience" type="radio" value="specific" class="h-4 w-4 text-blue-600 border-gray-300 focus:ring-blue-500" {{ (old('audience', $audience ?? 'folder') === 'specific') ? 'checked' : '' }}>
                        <label for="audience_specific" class="ms-3 block text-md font-medium text-gray-700">ئایدی تاک:</label>
                        <input type="text" name="specific_id" id="specific_id" class="ms-2 p-1 border border-gray-300 rounded-md shadow-sm focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition w-full sm:w-auto" value="{{ old('specific_id', $specific_id_value ?? '') }}">
                    </div>
                </div>
                @error('folder_id')
                <p class="text-red-500 text-sm mt-1 ms-3">{{ $message }}</p>
                @enderror
            </fieldset>

            <div>
                <button type="submit" class="w-full bg-blue-600 text-white font-bold text-lg py-3 px-4 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-transform transform hover:scale-105">
                    🚀 ناردن
                </button>
            </div>
        </form>

        @if (isset($results) && !empty($results))
            <div class="mt-8">
                <h2 class="text-xl font-bold text-gray-700 mb-4">ڕاپۆرتی ناردن:</h2>
                <div class="result-log p-4 rounded-md max-h-80 overflow-y-auto">
                    @foreach ($results as $result)
                        <div>{!! $result !!}</div>
                    @endforeach
                </div>
            </div>
        @endif
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const folderRadio = document.getElementById('audience_active');
        const allRadio = document.getElementById('audience_all');
        const specificRadio = document.getElementById('audience_specific');
        const folderSelect = document.getElementById('folder_id');

        function updateFolderSelectState() {
            folderSelect.disabled = !folderRadio.checked;
        }

        folderRadio.addEventListener('change', updateFolderSelectState);
        allRadio.addEventListener('change', updateFolderSelectState);
        specificRadio.addEventListener('change', updateFolderSelectState);

        updateFolderSelectState();
    });
</script>
</body>
</html>
