<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('assets', function (Blueprint $table) {
            $table->id();
            $table->foreignId('folder_id')->constrained('folders')->cascadeOnUpdate()->cascadeOnDelete();
            $table->string('type'); // text, photo, video, document, etc
            $table->string('file_id'); // Telegram file ID / Or message ID if it is text
            $table->string('title'); // The asset title
            $table->json('metadata')->nullable(); // Store additional info
            $table->unsignedMediumInteger('position')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('assets');
    }
};
