<?php

namespace App\Telegram\Menus\Admin;

use App\Models\Asset;
use App\Models\Folder;
use App\Models\User;
use SergiX44\Nutgram\Conversations\InlineMenu;
use SergiX44\Nutgram\Nutgram;
use SergiX44\Nutgram\Telegram\Types\Keyboard\InlineKeyboardButton;

class StatisticsMenu extends InlineMenu
{
    use Helpers;

    public function start(Nutgram $bot): void
    {
        if (!self::authorizeAdmin($bot, $this)) return;


        $assetsByType = Asset::selectRaw('type, count(*) as count')->groupBy('type')->get();

        $text = "📊 **Statistics**\n\n";
        $text .= "👥 Total Users: " . User::count() . "\n";
        $text .= "📁 Total Folders: " . Folder::count() . "\n";
        $text .= "📎 Total Assets: " . Asset::count() . "\n\n";

        if ($assetsByType->isNotEmpty()) {
            $text .= "**Assets by Type:**\n";
            foreach ($assetsByType as $asset) {
                $icon = $asset->getIcon();
                $text .= "{$icon} {$asset->type}: {$asset->count}\n";
            }
        } else {
            $text .= "No assets found.";
        }

        $this->menuText($text, ['parse_mode' => 'Markdown'])
            ->addButtonRow(InlineKeyboardButton::make('⬅️ Back', callback_data: 'back@goBack'))
            ->showMenu();
    }

    public function goBack(Nutgram $bot): void
    {
        $this->end();
        AdminMenu::begin($bot);
    }
}
