<?php

namespace App\Http\Controllers;

use App\Models\Folder;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class UserGrantAccessController extends Controller
{
    public function create()
    {
        $folders = Folder::where('parent_id', null)->orderBy('name')->get();
        return view('grant_access', compact('folders'));
    }



    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'folder_id' => 'required|exists:folders,id',
            'telegram_ids' => 'required|string',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        $folder = Folder::find($request->input('folder_id'));



        $telegramIds = preg_split('/[\s,]+/', $request->input('telegram_ids'));
        $telegramIds = array_filter(array_map('trim', $telegramIds)); // Clean up empty entries

        if (empty($telegramIds)) {
            return back()->with('error', 'No valid Telegram IDs were provided.');
        }


        $users = User::whereIn('telegram_id', $telegramIds)->get();
        $foundTelegramIds = $users->pluck('telegram_id')->toArray();
        $userIdsToAttach = $users->pluck('id')->toArray();


        $folder->users()->syncWithoutDetaching($userIdsToAttach);

        $notFoundIds = array_diff($telegramIds, $foundTelegramIds);
        $successMessage = count($userIdsToAttach) . ' user(s) were successfully added to the folder: "' . $folder->name . '".';

        $feedback = redirect()->route('folder-users.create')->with('success', $successMessage);

        if (!empty($notFoundIds)) {
            $feedback->with('info', 'The following Telegram IDs were not found: ' . implode(', ', $notFoundIds));
        }

        return $feedback;
    }
}
